package com.burhanstore.neonbubblequest.Utils.anim

import android.view.View

fun View.setClick(onClick: () -> Unit) {
    this.setOnClickListener {
        this.animate()
            .scaleX(0.94f)
            .scaleY(0.94f)
            .setDuration(100)
            .withEndAction {
                this.animate()
                    .scaleX(1f)
                    .scaleY(1f)
                    .setDuration(100)
                    .withEndAction {
                        onClick()
                    }
                    .start()
            }
            .start()
    }
}
